	function phas = phas(w,ph)

	% Computes the phase response at the given angular frequency w.
	% The phase is unwrapped such that |phas - ph| < pi.
	% The information of the allpass filter is carried by beta(j), ome(j), and
	% omexome(j) for j = 1,2,...,nall, nall is the order of the allpass filter
	
	% <-------------------------------------------------------------- << DH <<<
	% SYM_WDF.m -> linremez.m -> newgrid.m
	%                          -> iextnew.m
	%                          -> forcing.m -> forcehelp.m -> phas.m
	%                          -> phas.m
	%                          -> removeiext.m
	%            -> factors.m 
	% <---------------------------------------------------------------<< DH <<<
	% BETA,OME and OMEXOME are global variables.
	% <--- edited Jan-29-2007 with Matlab R2006a ---------------------<< DH <<<

% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	 
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	
	global OME OMEXOME BETA
	nall = length(OME);
	om = min(w,pi-10^-6);  % pi is not valid value
	om = tan(om/2);omxom = om^2;
	
	r0 = 1;i0 = 0;r1 = 1;
	i1 = BETA(1)*om;
	for i = 2:nall
		ii = i-1;
		a = BETA(i)*(OMEXOME(ii)-omxom);
		r2 = r1+a*r0;
		i2 = i1+a*i0;
		r0 = r1;i0 = i1;
		r1 = r2;i1 = i2;
		r2 = max(abs(r2),abs(i2));
		if (r2 > 10^6)
			r0 = r0/r2;i0 = i0/r2;
			r1 = r1/r2;i1 = i1/r2;
		end
	end
	p = 2*atan2(i1,r1);	
	uk = 1;
	while (uk == 1)
		uk = 0;
		if ((p-ph) > pi)
			p = p-2*pi;uk = 1;
		elseif ((ph-p) > pi)
			p = p+2*pi;uk = 1;
		end
	end
	phas = p;
